/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.user.service.impl;

import com.tp_link.eap.d.b;
import com.tp_link.eap.domain.account.Role;
import com.tp_link.eap.domain.account.User;
import com.tp_link.eap.domain.global.OperationResult;
import com.tp_link.eap.domain.site.Privilege;
import com.tp_link.eap.domain.site.Site;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.domain.ui.QueryPage;
import com.tp_link.eap.domain.ui.QuerySort;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.repo.site.SiteRepository;
import com.tp_link.eap.user.repo.PrivilegeRepository;
import com.tp_link.eap.user.repo.UserRepository;
import com.tp_link.eap.user.service.PrivilegeServiceI;
import com.tp_link.eap.util.a.a;
import com.tp_link.eap.util.a.e;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="privilegeService")
public class PrivilegeService
extends com.tp_link.eap.i.a.a<Privilege>
implements PrivilegeServiceI {
    @Autowired
    private PrivilegeRepository a;
    @Autowired
    private UserRepository b;
    @Autowired
    @Lazy
    private SiteRepository c;
    private Logger d = LoggerFactory.getLogger(this.getClass());

    public List<Privilege> getList(QueryPage queryPage) {
        return this.getList(queryPage, null);
    }

    public List<Privilege> getList(QueryPage queryPage, QuerySort querySort) {
        return this.getList(queryPage, querySort, null, null);
    }

    public List<Privilege> getList(QueryPage queryPage, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.getList(queryPage, null, filters, searchFilters);
    }

    public List<Privilege> getList(QueryPage queryPage, QuerySort querySort, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.a.getByFilters(queryPage, querySort, filters, searchFilters);
    }

    public long count(List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.a.countByFilters(filters, searchFilters);
    }

    @Override
    public List<Privilege> getUserPrivileges(String userName) {
        if (e.a((String)userName)) {
            return null;
        }
        ArrayList<QueryFilter> arrayList = new ArrayList<QueryFilter>();
        arrayList.add(new QueryFilter("userName", (Object)userName, QueryFilter.FilterType.eq));
        return this.getList(null, new QuerySort(QuerySort.SortDirection.asc, "id"), arrayList, null);
    }

    @Override
    public List<Privilege> getSitePrivileges(String siteName) {
        return this.a.findBySiteName(siteName);
    }

    @Override
    public OperationResult deleteUserPrivilege(String userName) {
        List<Privilege> list = this.getUserPrivileges(userName);
        if (!CollectionUtils.isEmpty(list)) {
            this.a.delete(list);
        }
        return com.tp_link.eap.util.e.bc;
    }

    @Override
    public OperationResult deleteSitePrivilege(String siteName) {
        List<Privilege> list = this.getSitePrivileges(siteName);
        if (!CollectionUtils.isEmpty(list)) {
            this.a.delete(list);
        }
        return com.tp_link.eap.util.e.bc;
    }

    @Override
    public OperationResult deleteAllPrivileges() {
        this.a.deleteAll();
        return com.tp_link.eap.util.e.bc;
    }

    @Override
    public OperationResult refreshPrivilege(Privilege privilege) {
        return null;
    }

    @Override
    public OperationResult assignSiteToUser(String userName, String siteName, Role siteRole) {
        Privilege privilege = new Privilege(userName, siteName, siteRole);
        this.a.save(privilege);
        return com.tp_link.eap.util.e.bc;
    }

    @Override
    public Privilege findPrivilegeByUserNameAndSiteName(String userName, String siteName) {
        return this.a.findByUserNameAndSiteName(userName, siteName);
    }

    @Override
    public void savePrivilege(Privilege privilege) {
        this.a.save(privilege);
    }

    @Override
    public OperationResult assignSiteToAdministrators(String siteName) {
        List<User> list = this.b.findByRoleName("administrator");
        if (!CollectionUtils.isEmpty(list)) {
            for (User user : list) {
                this.assignSiteToUser(user.getName(), siteName, user.getRole());
            }
        }
        return com.tp_link.eap.util.e.bc;
    }

    @Override
    public OperationResult unassignSitePrivileges(String siteName) {
        List<Privilege> list = this.a.findBySiteName(siteName);
        if (!CollectionUtils.isEmpty(list)) {
            this.a.delete(list);
        }
        return com.tp_link.eap.util.e.bc;
    }

    @Override
    public OperationResult refreshUserPrivileges(String userName, String oldUserName, Role oldRole, Role newRole) {
        List<Privilege> list;
        if (e.a((String)userName) || newRole == null) {
            return com.tp_link.eap.util.e.aX;
        }
        if (oldRole == null) {
            if (newRole.getName().equals("administrator")) {
                List list2 = com.tp_link.eap.util.a.a.a((Iterable)this.c.findAll());
                if (!CollectionUtils.isEmpty((Collection)list2)) {
                    for (Site site : list2) {
                        this.assignSiteToUser(userName, site.getSiteName(), newRole);
                    }
                }
            } else {
                this.assignSiteToUser(userName, com.tp_link.eap.d.b.a(), newRole);
            }
        } else if (!newRole.getName().equals(oldRole.getName())) {
            List<Privilege> list3 = this.a.findByUserName(oldUserName);
            if (newRole.getName().equals("administrator")) {
                List list4;
                if (!CollectionUtils.isEmpty(list3)) {
                    this.a.delete(list3);
                }
                if (!CollectionUtils.isEmpty((Collection)(list4 = com.tp_link.eap.util.a.a.a((Iterable)this.c.findAll())))) {
                    for (Site site : list4) {
                        this.assignSiteToUser(userName, site.getSiteName(), newRole);
                    }
                }
            } else if (oldRole.getName().equals("administrator")) {
                if (!CollectionUtils.isEmpty(list3) && !CollectionUtils.isEmpty(list3)) {
                    this.a.delete(list3);
                }
                this.assignSiteToUser(userName, com.tp_link.eap.d.b.a(), newRole);
            } else if (!CollectionUtils.isEmpty(list3) && !CollectionUtils.isEmpty(list3)) {
                for (Privilege privilege : list3) {
                    privilege.setUserName(userName);
                    privilege.setRole(newRole);
                }
                this.a.save(list3);
            }
        } else if (!(oldUserName.equals(userName) || CollectionUtils.isEmpty(list = this.a.findByUserName(oldUserName)) || CollectionUtils.isEmpty(list))) {
            for (Privilege privilege : list) {
                privilege.setUserName(userName);
            }
            this.a.save(list);
        }
        return com.tp_link.eap.util.e.bc;
    }

    @Override
    public OperationResponse refreshUserPrivileges(String userName, List<String> siteNames) {
        User user = this.b.findByName(userName);
        if (user == null) {
            this.d.warn("User {} not exist.", (Object)user.getName());
            return new OperationResponse(ResErrorCode.ct);
        }
        Role role = user.getRole();
        OperationResponse operationResponse = this.refreshUserPrivileges(userName, siteNames, role);
        if (!operationResponse.success()) {
            return operationResponse;
        }
        String string = this.a(user.getLastSite(), siteNames);
        if (!string.equals(user.getLastSite())) {
            user.setLastSite(string);
            this.b.save(user);
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse refreshUserPrivileges(String userName, List<String> siteNames, Role role) {
        if (e.a((String)userName)) {
            return new OperationResponse(ResErrorCode.b);
        }
        List<Privilege> list = this.a.findByUserName(userName);
        if (!CollectionUtils.isEmpty(list)) {
            this.a.delete(list);
        }
        boolean bl = true;
        if (!CollectionUtils.isEmpty(siteNames)) {
            for (String string : siteNames) {
                this.assignSiteToUser(userName, string, role);
            }
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public Privilege getUserSitePrivilege(String userName, String siteName) {
        return this.a.findByUserNameAndSiteName(userName, siteName);
    }

    @Override
    public void savePrivlileges(List<Privilege> privileges) {
        this.a.save(privileges);
    }

    @Override
    public List<Privilege> getAll() {
        return com.tp_link.eap.util.a.a.a((Iterable)this.a.findAll());
    }

    private String a(String string, List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        if (string == null) {
            return list.get(0);
        }
        for (String string2 : list) {
            if (!string2.equals(string)) continue;
            return string;
        }
        return list.get(0);
    }
}

